function [weightNODE] = ...
    GetNodeWeight(NODEquery,NODE,ELEM,gammaw,ELEMgamma,waterPoints)
narginchk(4,6)

Ne = length(ELEM);
Nn = size(NODEquery,1);
dL = max(NODE) - min(NODE);
tol = 1e-5 * sqrt(prod(dL)/Nn);

if (nargin<4)
    ELEMgamma = ones(Ne,1); % The output in this case will be the depth
end
if (nargin==6)
    waterPoints = CleanWaterTable(waterPoints);
end

weightNODE = nan(Nn,1);
weightSTACK = nan(64,3); % We assume a weight stack no bigger than 64
for i=1:Nn
    Ns = 0;
    for j=1:Ne
        ELEMnode = NODE(ELEM{j}(:),:);
        if (max(ELEMnode(:,2))>NODEquery(i,2)-tol && max(ELEMnode(:,1))>NODEquery(i,1)-tol && min(ELEMnode(:,1))<NODEquery(i,1)+tol)
            [Zbot,Ztop] = NodeHitbox(NODEquery(i,1),ELEMnode);
            if ~any(isinf([Zbot Ztop])) % If this element is above/below NODEqueryX
                Ns = Ns + 1;
                weightSTACK(Ns,:) = [Zbot Ztop ELEMgamma(j)];
            end
        end
    end
    
    % Process the weight stack into a train
    if (Ns==0)
        weightNODE(i) = 0;
    else
        TRAINsplit = uniquetol(max(weightSTACK(1:Ns,1:2),NODEquery(i,2)),tol);
        if isrow(TRAINsplit), TRAINsplit = TRAINsplit'; end
        % Unique's output is sorted. max() makes the train begin at NODEz
        Lt = length(TRAINsplit)-1;
        TRAINload = zeros(Lt,1);
        TRAINcars = zeros(Lt,1);
        for j=1:Ns
            for k=1:Lt
                % If stack material is lighter, do nothing
                if TRAINload(k)<weightSTACK(j,3)
                    % The <= and > below are necesary: do not change!
                    if (weightSTACK(j,1)<=TRAINsplit(k+1)) && (weightSTACK(j,2)>TRAINsplit(k))
                        TRAINload(k) = TRAINload(k) + weightSTACK(j,3);
                        TRAINcars(k) = TRAINcars(k) + 1;
                    end
                end
            end
        end

        
        if any(TRAINcars==0)
            error('Section in the load train has zero contributors.')
        end
        
        if (nargin==6)
            queryWT = interp1(waterPoints(:,1),waterPoints(:,2),NODEquery(i,1),'linear','extrap');
            if (queryWT>TRAINsplit(end))
                aux = sum(diff(TRAINsplit).*TRAINload./TRAINcars);
                TRAINsplit = [TRAINsplit; queryWT];
                TRAINload = [TRAINload; gammaw];
                TRAINcars = [TRAINcars; 1]; % No overlapping cars
            end
        end
        weightNODE(i) = sum(diff(TRAINsplit).*TRAINload./TRAINcars);
    end
end


return


function [Zbot,Ztop] = NodeHitbox(NODEqueryX,ELEMnode)

tol = 1e-8;
Ztop = -Inf;
Zbot =  Inf;

EDGE = nan(2,2);
EDGE(2,:) = ELEMnode(end,:); % Kickstart loading the last node

for i=1:size(ELEMnode,1)
    EDGE(1,:) = EDGE(2,:);
    EDGE(2,:) = ELEMnode(i,:);
    
    if diff(EDGE(:,1))~=0 % If perfectly vertical, do nothing
        D = diff(EDGE);
        EDGEextend = EDGE + tol*[-D; D];
        
        if EDGEextend(1,1)>EDGEextend(2,1) % If x_1>x_2
            EDGEextend = flipud(EDGEextend);
        end
        
        if (NODEqueryX >= EDGEextend(1,1)) && (NODEqueryX <= EDGEextend(2,1))
            Zhit = interp1(EDGEextend(:,1),EDGEextend(:,2),NODEqueryX,'linear');
            Ztop = max(Zhit,Ztop);
            Zbot = min(Zhit,Zbot);
        end
    end
end
return


function [XY] = CleanWaterTable(P)

Np = size(P,1);
lims = [min(P); max(P)];
win = diff(lims,1);
dist_tol = 1e-4 * nthroot(prod(win)/Np,size(P,2)); % Node--node tolerance

map = nan(Np,1);
keep = false(Np,1);
k = 0;
for i=1:Np
    if isnan(map(i))
        k = k + 1;
        map(i) = k;
        keep(i) = true;
        
        if (i<Np)
            D = P(i+1:end,:) - repmat(P(i,:),Np-i,1);
            dist = vecnorm(D,2,2);
            ind = find(dist<dist_tol);
            map(i+ind) = k;
        end
    end
end

XY = P(keep,:);
[~,ind] = sort(XY(:,1));
XY = XY(ind,:);
return